/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.util;

import com.ibm.hwmca.fw.servlet.pmod.ModelContentHandler;
import com.ibm.hwmca.fw.servlet.pmod.ModelContentTCFException;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.servlet.pmod.impl.SourceLocationIntrested;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Node;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.TextNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.srcloc.Location;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;

public final class StreamingContentHandler
implements ModelContentHandler,
SourceLocationIntrested {
    private static final String TRACE_MASKT = "XPMUSCHT";
    private static final String TRACE_MASKF = "XPMUSCHF";
    private CountingWriter writer = null;
    private SerializationReader reader = null;
    private PanelModel panelModel = null;
    private boolean starting = false;
    private String strata = null;
    private String source = null;
    private boolean serializing = false;
    private TreeMap db = new TreeMap();
    private Node lastNode = null;

    public StreamingContentHandler(PanelModel panelModel) {
        this.reset(panelModel);
    }

    public synchronized Reader getReader() throws IOException {
        Trace.trace(TRACE_MASKF, "getReader() in StreamingContentHandler[" + this + "], pm=" + this.panelModel);
        if (this.reader == null) {
            this.writer = new CountingWriter();
            this.reader = new SerializationReader(this.writer);
            Thread pms = new Thread("StreamingContentHandler Serializer"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block8: {
                        Trace.trace(StreamingContentHandler.TRACE_MASKF, "StreamingContentHandler Serializer begins running.");
                        StreamingContentHandler.this.panelModel.serialize(StreamingContentHandler.this);
                        Object var3_1 = null;
                        try {
                            StreamingContentHandler.this.writer.close();
                        }
                        catch (Exception e2) {}
                        break block8;
                        {
                            catch (Exception e) {
                                Trace.trace(StreamingContentHandler.TRACE_MASKT, "Exception while calling serialize()");
                                Trace.trace(StreamingContentHandler.TRACE_MASKT, "posting to nested reader.", e);
                                StreamingContentHandler.this.reader.postException(new IOException(e.getMessage()));
                                Object var3_2 = null;
                                try {
                                    StreamingContentHandler.this.writer.close();
                                }
                                catch (Exception e2) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            try {
                                StreamingContentHandler.this.writer.close();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            };
            pms.setDaemon(true);
            pms.start();
        }
        return this.reader;
    }

    public synchronized void reset(PanelModel panelModel) {
        this.writer = null;
        this.reader = null;
        this.panelModel = panelModel;
        this.starting = false;
        this.strata = null;
        this.source = null;
        this.serializing = false;
        this.db.clear();
        this.lastNode = null;
    }

    private String getAttributesAsString(Properties attributes) {
        if (attributes == null) {
            return "";
        }
        if (!attributes.keySet().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = attributes.getProperty(key);
                sb.append(" ".concat(key).concat("=\"").concat(value == null ? "" : value).concat("\""));
            }
            return sb.toString();
        }
        return "";
    }

    public void catchElement(String tagPrefix, String tagName, ModelContentTCFException exception) throws PanelModelException {
    }

    public synchronized void startDocument() throws PanelModelException {
        if (this.serializing) {
            throw new PanelModelException("Attempted concurrent use of StreamingContentHandler instance or use without resetting after prior use!");
        }
        this.serializing = true;
    }

    public void tagLocation(String strata, String source, int line, int column, Node node) {
        this.strata = strata;
        this.source = source;
        if (this.lastNode != null) {
            this.db.put(new Integer(this.writer.getCount()), this.lastNode);
        }
        this.lastNode = node;
    }

    public Location queryLocation(int index) {
        Iterator iterator = this.db.keySet().iterator();
        if (iterator.hasNext()) {
            Node node;
            Integer key;
            Integer lastKey = key = (Integer)iterator.next();
            Node lastNode = node = (Node)this.db.get(iterator.next());
            while (index < key) {
                lastKey = key;
                key = (Integer)iterator.next();
                lastNode = node;
                node = (Node)this.db.get(iterator.next());
            }
            if (lastNode instanceof TextNode) {
                int diff = index - lastKey;
                int line = lastNode.getDocumentLineLocation();
                int column = lastNode.getDocumentColumnLocation();
                char[] chars = ((TextNode)lastNode).getText().toCharArray();
                int i = 0;
                while (i < chars.length && diff > 0) {
                    if (chars[i] == '\n') {
                        ++line;
                        column = 0;
                    } else {
                        ++column;
                    }
                    ++i;
                    --diff;
                }
                return new Location(this.strata, this.source, line, column);
            }
            return new Location(this.strata, this.source, lastNode.getDocumentLineLocation(), lastNode.getDocumentColumnLocation());
        }
        return null;
    }

    public int startElement(String prefix, String name, Properties attributes, boolean isBodyEmpty) throws PanelModelException {
        try {
            if (this.starting) {
                this.writer.write(">");
            }
            this.writer.write("<".concat((prefix != null && !"".equals(prefix) ? prefix + ":" : "") + name).concat(this.getAttributesAsString(attributes)));
        }
        catch (Exception e) {
            this.error(new PanelModelException(e.getMessage()), "");
        }
        this.starting = true;
        return 0;
    }

    public int endElement(String prefix, String name) throws PanelModelException {
        block3: {
            try {
                if (this.starting) {
                    this.writer.write("/>");
                    this.starting = false;
                    break block3;
                }
                this.writer.write("</".concat((prefix != null && !"".equals(prefix) ? prefix + ":" : "") + name).concat(">"));
            }
            catch (Exception e) {
                this.error(new PanelModelException(e.getMessage()), "");
            }
        }
        return 0;
    }

    public void endDocument() throws PanelModelException {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            this.error(new PanelModelException(e.getMessage()), "");
        }
        if (this.lastNode != null) {
            this.db.put(new Integer(this.writer.getCount()), this.lastNode);
        }
    }

    public void characters(char[] ch, int start, int length) throws PanelModelException {
        try {
            if (this.starting) {
                this.writer.write(">");
                this.starting = false;
            }
            this.writer.write(ch, start, length);
        }
        catch (Exception e) {
            this.error(new PanelModelException(e.getMessage()), "");
        }
    }

    public void jspELExpression(char[] ch, int start, int length) throws PanelModelException {
        this.characters(ch, start, length);
    }

    public void jspDirective(char[] ch, int start, int length) throws PanelModelException {
        this.characters(ch, start, length);
    }

    public void startIgnoredConstruct(String prefix) throws PanelModelException {
        try {
            if (this.starting) {
                this.writer.write(">");
                this.starting = false;
            }
            this.writer.write(prefix);
        }
        catch (Exception e) {
            this.error(new PanelModelException(e.getMessage()), "");
        }
    }

    public void endIgnoredConstruct(String suffix) throws PanelModelException {
        this.startIgnoredConstruct(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(PanelModelException e, String location) {
        try {
            this.reader.postException(new IOException((e == null ? "null" : e.getMessage()) + " at " + location));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.reader.close();
            }
            catch (Exception otis) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.reader.close();
        }
        catch (Exception otis) {}
    }

    static class SerializationReader
    extends PipedReader {
        IOException exception = null;

        SerializationReader(PipedWriter writer) throws IOException {
            super(writer);
        }

        public void postException(IOException exception) {
            this.exception = exception;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return super.read(cbuf, off, len);
        }

        public void close() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            super.close();
        }

        public int read() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return super.read();
        }

        public boolean ready() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return super.ready();
        }

        public int read(char[] cbuf) throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return super.read(cbuf);
        }

        public long skip(long n) throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            return super.skip(n);
        }

        public void reset() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            super.reset();
        }

        public void mark(int readAheadLimit) throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            super.mark(readAheadLimit);
        }
    }

    static class CountingWriter
    extends PipedWriter {
        private int count = 0;

        CountingWriter() {
        }

        public int getCount() {
            return this.count;
        }

        public void resetCount() {
            this.count = 0;
        }

        public void write(int c) throws IOException {
            super.write(c);
            ++this.count;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            super.write(cbuf, off, len);
            this.count += len;
        }

        public void write(String str) throws IOException {
            super.write(str);
            this.count += str.length();
        }

        public void write(String str, int off, int len) throws IOException {
            super.write(str, off, len);
            this.count += len;
        }

        public void write(char[] cbuf) throws IOException {
            super.write(cbuf);
            this.count += cbuf.length;
        }
    }
}

